/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.DeployerRenderState;
import com.zurrtum.create.compat.eiv.display.DeployingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class DeployingView
extends CreateView {
    private final List<SlotContent> results;
    private final List<Float> chances;
    private final SlotContent target;
    private final SlotContent ingredient;
    private final boolean keepHeldItem;

    public DeployingView(DeployingDisplay display) {
        this.results = display.results.stream().map(SlotContent::of).toList();
        this.chances = display.chances;
        this.target = SlotContent.of((List)display.target);
        this.ingredient = SlotContent.of((List)display.ingredient);
        this.keepHeldItem = display.keepHeldItem;
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.DEPLOYING;
    }

    public List<SlotContent> getIngredients() {
        return List.of(this.ingredient, this.target);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    public int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int i;
        int size = this.results.size();
        if (size == 1) {
            slotDefinition.addItemSlot(i++, 132, 53);
        } else {
            for (i = 0; i < size; ++i) {
                slotDefinition.addItemSlot(i, i % 2 == 0 ? 122 : 141, 53 + i / 2 * -19);
            }
        }
        slotDefinition.addItemSlot(i++, 51, 7);
        slotDefinition.addItemSlot(i++, 27, 53);
        return i;
    }

    @Override
    public int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        int size = this.results.size();
        for (i = 0; i < size; ++i) {
            float chance = this.chances.get(i).floatValue();
            if (chance == 1.0f) {
                slotFillContext.bindOptionalSlot(i, this.results.get(i), SLOT);
                continue;
            }
            this.bindChanceSlot(slotFillContext, i, this.results.get(i), chance);
        }
        if (this.keepHeldItem) {
            slotFillContext.addAdditionalStackModifier(i, NOT_CONSUMED);
        }
        slotFillContext.bindOptionalSlot(i++, this.ingredient, SLOT);
        slotFillContext.bindOptionalSlot(i++, this.target, SLOT);
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_SHADOW.render(context, 62, 59);
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 126, this.results.size() <= 2 ? 31 : 12);
        context.field_59826.method_70922((class_11256)new DeployerRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 75, -8));
    }
}

